<?php
defined('_JEXEC') or die;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Response\JsonResponse;

class VicentaotvControllerVideo extends BaseController {
    public function generate() {
        $app = Factory::getApplication();
        $input = $app->input;
        $prompt = $input->getString('prompt', '');
        $workflow = $input->getString('workflow', '');
        $api = rtrim($this->getParam('assistant_api_url', ''), '/');
        if (!$api) { $this->respond(['ok'=>false,'error'=>'assistant_api_url não configurado']); return; }
        $payload = ['prompt'=>$prompt, 'workflow'=>$workflow];
        $res = $this->postJson("{$api}/video", $payload);
        $this->respond($res);
    }
    private function getParam($key, $default=''){
        $params = ComponentHelper::getParams('com_vicentaotv');
        return $params->get($key, $default);
    }
    private function respond($data){
        $app = Factory::getApplication();
        echo new JsonResponse($data);
        $app->close();
    }
    private function postJson($url, $payload){
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        $body = curl_exec($ch);
        $err = curl_error($ch);
        $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        if ($err) return ['ok'=>false,'error'=>$err];
        $json = json_decode($body, true);
        if (!$json) return ['ok'=>false,'error'=>"HTTP $status", 'raw'=>$body];
        return $json;
    }
}
