<?php
declare(strict_types=1);

namespace Vicentaotv\Component\Vicentaotv\Site\Controller;

use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Response\JsonResponse;

class VideoController extends BaseController
{
    public function generate(): void
    {
        $app = Factory::getApplication();
        $input = $app->input;
        $data = json_decode($input->json->getRaw(), true) ?: [];
        $prompt = $data['prompt'] ?? '';
        $workflow = $data['workflow'] ?? 'basic_video.json';
        $params = ComponentHelper::getParams('com_vicentaotv');
        $comfyUrl = (string)$params->get('comfy_url');

        echo new JsonResponse([
            'success' => true,
            'status' => 'queued',
            'prompt' => $prompt,
            'workflow' => $workflow,
            'comfyUrl' => $comfyUrl,
        ]);
    }
}
